<?php
$assets = get_stylesheet_directory_uri() . '/assets';
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<header class="site-header">
  <div class="site-logo">
    <img src="<?php echo $assets; ?>/logos.jpg" alt="Clearly Financial + FeeAdvocates logos">
  </div>
  <div class="site-title">Clearly Financial &ndash; FeeAdvocates</div>
</header>
<nav class="nav">
  <?php
    if (has_nav_menu('primary')) {
        wp_nav_menu(array('theme_location' => 'primary', 'container' => false));
    } else {
        echo '<a href="/">Home</a> <a href="/about">About</a> <a href="/services">Services</a> <a href="/testimonials">Testimonials</a> <a href="/contact">Contact</a>';
    }
  ?>
</nav>
